/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.subjects.UnicastSubject;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableWindow$WindowExactObserver<T>
extends AtomicInteger
implements Observer<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = -7481782523886138128L;
    final Observer<? super Observable<T>> actual;
    final long count;
    final int capacityHint;
    long size;
    Disposable s;
    UnicastSubject<T> window;
    volatile boolean cancelled;

    ObservableWindow$WindowExactObserver(Observer<? super Observable<T>> actual, long count, int capacityHint) {
        this.actual = actual;
        this.count = count;
        this.capacityHint = capacityHint;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        UnicastSubject<T> w2 = this.window;
        if (w2 == null && !this.cancelled) {
            w2 = UnicastSubject.create(this.capacityHint, this);
            this.window = w2;
            this.actual.onNext(w2);
        }
        if (w2 != null) {
            w2.onNext(t2);
            if (++this.size >= this.count) {
                this.size = 0L;
                this.window = null;
                w2.onComplete();
                if (this.cancelled) {
                    this.s.dispose();
                }
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        UnicastSubject<T> w2 = this.window;
        if (w2 != null) {
            this.window = null;
            w2.onError(t2);
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        UnicastSubject<T> w2 = this.window;
        if (w2 != null) {
            this.window = null;
            w2.onComplete();
        }
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        this.cancelled = true;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public void run() {
        if (this.cancelled) {
            this.s.dispose();
        }
    }
}

