/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.schedulers.Timed;
import java.util.concurrent.TimeUnit;

final class ObservableTimeInterval$TimeIntervalObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super Timed<T>> actual;
    final TimeUnit unit;
    final Scheduler scheduler;
    long lastTime;
    Disposable s;

    ObservableTimeInterval$TimeIntervalObserver(Observer<? super Timed<T>> actual, TimeUnit unit, Scheduler scheduler) {
        this.actual = actual;
        this.scheduler = scheduler;
        this.unit = unit;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.lastTime = this.scheduler.now(this.unit);
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        long now = this.scheduler.now(this.unit);
        long last = this.lastTime;
        this.lastTime = now;
        long delta = now - last;
        this.actual.onNext(new Timed<T>(t2, delta, this.unit));
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }
}

