/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableThrottleFirstTimed$DebounceTimedObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable,
Runnable {
    private static final long serialVersionUID = 786994795061867455L;
    final Observer<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    Disposable s;
    volatile boolean gate;
    boolean done;

    ObservableThrottleFirstTimed$DebounceTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.gate && !this.done) {
            this.gate = true;
            this.actual.onNext(t2);
            Disposable d2 = (Disposable)this.get();
            if (d2 != null) {
                d2.dispose();
            }
            DisposableHelper.replace(this, this.worker.schedule(this, this.timeout, this.unit));
        }
    }

    @Override
    public void run() {
        this.gate = false;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
        } else {
            this.done = true;
            this.actual.onError(t2);
            this.worker.dispose();
        }
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.actual.onComplete();
            this.worker.dispose();
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
        this.worker.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.worker.isDisposed();
    }
}

