/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableTake$TakeObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    boolean done;
    Disposable subscription;
    long remaining;

    ObservableTake$TakeObserver(Observer<? super T> actual, long limit) {
        this.actual = actual;
        this.remaining = limit;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.subscription, s2)) {
            this.subscription = s2;
            if (this.remaining == 0L) {
                this.done = true;
                s2.dispose();
                EmptyDisposable.complete(this.actual);
            } else {
                this.actual.onSubscribe(this);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done && this.remaining-- > 0L) {
            boolean stop = this.remaining == 0L;
            this.actual.onNext(t2);
            if (stop) {
                this.onComplete();
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.subscription.dispose();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.subscription.dispose();
            this.actual.onComplete();
        }
    }

    @Override
    public void dispose() {
        this.subscription.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.subscription.isDisposed();
    }
}

