/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableSwitchMap$SwitchMapInnerObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableSwitchMap$SwitchMapObserver<T, R>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -3491074160481096299L;
    final Observer<? super R> actual;
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;
    final AtomicThrowable errors;
    volatile boolean done;
    volatile boolean cancelled;
    Disposable s;
    final AtomicReference<ObservableSwitchMap$SwitchMapInnerObserver<T, R>> active = new AtomicReference();
    static final ObservableSwitchMap$SwitchMapInnerObserver<Object, Object> CANCELLED = new ObservableSwitchMap$SwitchMapInnerObserver(null, -1L, 1);
    volatile long unique;

    ObservableSwitchMap$SwitchMapObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        this.actual = actual;
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
        this.errors = new AtomicThrowable();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        ObservableSource<R> p2;
        long c2;
        this.unique = c2 = this.unique + 1L;
        ObservableSwitchMap$SwitchMapInnerObserver<T, R> inner = this.active.get();
        if (inner != null) {
            inner.cancel();
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The ObservableSource returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.dispose();
            this.onError(e2);
            return;
        }
        ObservableSwitchMap$SwitchMapInnerObserver nextInner = new ObservableSwitchMap$SwitchMapInnerObserver(this, c2, this.bufferSize);
        while ((inner = this.active.get()) != CANCELLED) {
            if (!this.active.compareAndSet(inner, nextInner)) continue;
            p2.subscribe(nextInner);
            break;
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done || !this.errors.addThrowable(t2)) {
            if (!this.delayErrors) {
                this.disposeInner();
            }
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.drain();
        }
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.dispose();
            this.disposeInner();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void disposeInner() {
        ObservableSwitchMap$SwitchMapInnerObserver<Object, Object> a2 = this.active.get();
        if (a2 != CANCELLED && (a2 = this.active.getAndSet(CANCELLED)) != CANCELLED && a2 != null) {
            a2.cancel();
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Observer<R> a2 = this.actual;
        int missing = 1;
        while (true) {
            ObservableSwitchMap$SwitchMapInnerObserver<T, R> inner;
            if (this.cancelled) {
                return;
            }
            if (this.done) {
                Throwable ex2;
                boolean empty;
                boolean bl2 = empty = this.active.get() == null;
                if (this.delayErrors) {
                    if (empty) {
                        ex2 = (Throwable)this.errors.get();
                        if (ex2 != null) {
                            a2.onError(ex2);
                        } else {
                            a2.onComplete();
                        }
                        return;
                    }
                } else {
                    ex2 = (Throwable)this.errors.get();
                    if (ex2 != null) {
                        a2.onError(this.errors.terminate());
                        return;
                    }
                    if (empty) {
                        a2.onComplete();
                        return;
                    }
                }
            }
            if ((inner = this.active.get()) != null) {
                Throwable ex3;
                SpscLinkedArrayQueue q2 = inner.queue;
                if (inner.done) {
                    boolean empty = q2.isEmpty();
                    if (this.delayErrors) {
                        if (empty) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    } else {
                        ex3 = (Throwable)this.errors.get();
                        if (ex3 != null) {
                            a2.onError(this.errors.terminate());
                            return;
                        }
                        if (empty) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    }
                }
                boolean retry = false;
                while (true) {
                    boolean empty;
                    if (this.cancelled) {
                        return;
                    }
                    if (inner != this.active.get()) {
                        retry = true;
                        break;
                    }
                    if (!this.delayErrors && (ex3 = (Throwable)this.errors.get()) != null) {
                        a2.onError(this.errors.terminate());
                        return;
                    }
                    boolean d2 = inner.done;
                    Object v2 = q2.poll();
                    boolean bl3 = empty = v2 == null;
                    if (d2 && empty) {
                        this.active.compareAndSet(inner, null);
                        retry = true;
                        break;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                }
                if (retry) continue;
            }
            if ((missing = this.addAndGet(-missing)) == 0) break;
        }
    }

    void innerError(ObservableSwitchMap$SwitchMapInnerObserver<T, R> inner, Throwable ex2) {
        if (inner.index == this.unique && this.errors.addThrowable(ex2)) {
            if (!this.delayErrors) {
                this.s.dispose();
            }
            inner.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    static {
        CANCELLED.cancel();
    }
}

