/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableSwitchMap$SwitchMapObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableSwitchMap$SwitchMapInnerObserver<T, R>
extends AtomicReference<Disposable>
implements Observer<R> {
    private static final long serialVersionUID = 3837284832786408377L;
    final ObservableSwitchMap$SwitchMapObserver<T, R> parent;
    final long index;
    final SpscLinkedArrayQueue<R> queue;
    volatile boolean done;

    ObservableSwitchMap$SwitchMapInnerObserver(ObservableSwitchMap$SwitchMapObserver<T, R> parent, long index, int bufferSize) {
        this.parent = parent;
        this.index = index;
        this.queue = new SpscLinkedArrayQueue(bufferSize);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        DisposableHelper.setOnce(this, s2);
    }

    @Override
    public void onNext(R t2) {
        if (this.index == this.parent.unique) {
            this.queue.offer(t2);
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.parent.innerError(this, t2);
    }

    @Override
    public void onComplete() {
        if (this.index == this.parent.unique) {
            this.done = true;
            this.parent.drain();
        }
    }

    public void cancel() {
        DisposableHelper.dispose(this);
    }
}

