/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableSkipLastTimed$SkipLastTimedObserver<T>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -5677354903406201275L;
    final Observer<? super T> actual;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SpscLinkedArrayQueue<Object> queue;
    final boolean delayError;
    Disposable s;
    volatile boolean cancelled;
    volatile boolean done;
    Throwable error;

    ObservableSkipLastTimed$SkipLastTimedObserver(Observer<? super T> actual, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        this.actual = actual;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        long now = this.scheduler.now(this.unit);
        q2.offer(now, t2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Observer<Object> a2 = this.actual;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        boolean delayError = this.delayError;
        TimeUnit unit = this.unit;
        Scheduler scheduler = this.scheduler;
        long time = this.time;
        while (true) {
            if (this.cancelled) {
                this.queue.clear();
                return;
            }
            boolean d2 = this.done;
            Long ts2 = (Long)q2.peek();
            boolean empty = ts2 == null;
            long now = scheduler.now(unit);
            if (!empty && ts2 > now - time) {
                empty = true;
            }
            if (d2) {
                Throwable e2;
                if (delayError) {
                    if (empty) {
                        e2 = this.error;
                        if (e2 != null) {
                            a2.onError(e2);
                        } else {
                            a2.onComplete();
                        }
                        return;
                    }
                } else {
                    e2 = this.error;
                    if (e2 != null) {
                        this.queue.clear();
                        a2.onError(e2);
                        return;
                    }
                    if (empty) {
                        a2.onComplete();
                        return;
                    }
                }
            }
            if (!empty) {
                q2.poll();
                Object v2 = q2.poll();
                a2.onNext(v2);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }
}

