/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.operators.observable.ObservableSequenceEqual$EqualObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableSequenceEqual$EqualCoordinator<T>
extends AtomicInteger
implements Disposable {
    private static final long serialVersionUID = -6178010334400373240L;
    final Observer<? super Boolean> actual;
    final BiPredicate<? super T, ? super T> comparer;
    final ArrayCompositeDisposable resources;
    final ObservableSource<? extends T> first;
    final ObservableSource<? extends T> second;
    final ObservableSequenceEqual$EqualObserver<T>[] observers;
    volatile boolean cancelled;
    T v1;
    T v2;

    ObservableSequenceEqual$EqualCoordinator(Observer<? super Boolean> actual, int bufferSize, ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer) {
        this.actual = actual;
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        ObservableSequenceEqual$EqualObserver[] as2 = new ObservableSequenceEqual$EqualObserver[2];
        this.observers = as2;
        as2[0] = new ObservableSequenceEqual$EqualObserver(this, 0, bufferSize);
        as2[1] = new ObservableSequenceEqual$EqualObserver(this, 1, bufferSize);
        this.resources = new ArrayCompositeDisposable(2);
    }

    boolean setDisposable(Disposable s2, int index) {
        return this.resources.setResource(index, s2);
    }

    void subscribe() {
        ObservableSequenceEqual$EqualObserver<T>[] as2 = this.observers;
        this.first.subscribe(as2[0]);
        this.second.subscribe(as2[1]);
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.resources.dispose();
            if (this.getAndIncrement() == 0) {
                ObservableSequenceEqual$EqualObserver<T>[] as2 = this.observers;
                as2[0].queue.clear();
                as2[1].queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    void cancel(SpscLinkedArrayQueue<T> q1, SpscLinkedArrayQueue<T> q2) {
        this.cancelled = true;
        q1.clear();
        q2.clear();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        ObservableSequenceEqual$EqualObserver<T>[] as2 = this.observers;
        ObservableSequenceEqual$EqualObserver<T> s1 = as2[0];
        SpscLinkedArrayQueue q1 = s1.queue;
        ObservableSequenceEqual$EqualObserver<T> s2 = as2[1];
        SpscLinkedArrayQueue q2 = s2.queue;
        while (true) {
            boolean e2;
            boolean e1;
            Throwable e3;
            Throwable e4;
            if (this.cancelled) {
                q1.clear();
                q2.clear();
                return;
            }
            boolean d1 = s1.done;
            if (d1 && (e4 = s1.error) != null) {
                this.cancel(q1, q2);
                this.actual.onError(e4);
                return;
            }
            boolean d2 = s2.done;
            if (d2 && (e3 = s2.error) != null) {
                this.cancel(q1, q2);
                this.actual.onError(e3);
                return;
            }
            if (this.v1 == null) {
                this.v1 = q1.poll();
            }
            boolean bl2 = e1 = this.v1 == null;
            if (this.v2 == null) {
                this.v2 = q2.poll();
            }
            boolean bl3 = e2 = this.v2 == null;
            if (d1 && d2 && e1 && e2) {
                this.actual.onNext((Boolean)true);
                this.actual.onComplete();
                return;
            }
            if (d1 && d2 && e1 != e2) {
                this.cancel(q1, q2);
                this.actual.onNext((Boolean)false);
                this.actual.onComplete();
                return;
            }
            if (!e1 && !e2) {
                boolean c2;
                try {
                    c2 = this.comparer.test(this.v1, this.v2);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.cancel(q1, q2);
                    this.actual.onError(ex2);
                    return;
                }
                if (!c2) {
                    this.cancel(q1, q2);
                    this.actual.onNext((Boolean)false);
                    this.actual.onComplete();
                    return;
                }
                this.v1 = null;
                this.v2 = null;
            }
            if (!e1 && !e2) continue;
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }
}

