/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableScanSeed$ScanSeedObserver<T, R>
implements Observer<T>,
Disposable {
    final Observer<? super R> actual;
    final BiFunction<R, ? super T, R> accumulator;
    R value;
    Disposable s;
    boolean done;

    ObservableScanSeed$ScanSeedObserver(Observer<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
        this.actual = actual;
        this.accumulator = accumulator;
        this.value = value;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            this.actual.onNext(this.value);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        R u2;
        if (this.done) {
            return;
        }
        R v2 = this.value;
        try {
            u2 = ObjectHelper.requireNonNull(this.accumulator.apply(v2, t2), "The accumulator returned a null value");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.dispose();
            this.onError(e2);
            return;
        }
        this.value = u2;
        this.actual.onNext(u2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }
}

