/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableScan$ScanObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final BiFunction<T, T, T> accumulator;
    Disposable s;
    T value;
    boolean done;

    ObservableScan$ScanObserver(Observer<? super T> actual, BiFunction<T, T, T> accumulator) {
        this.actual = actual;
        this.accumulator = accumulator;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        Observer<T> a2 = this.actual;
        T v2 = this.value;
        if (v2 == null) {
            this.value = t2;
            a2.onNext(t2);
        } else {
            T u2;
            try {
                u2 = ObjectHelper.requireNonNull(this.accumulator.apply(v2, t2), "The value returned by the accumulator is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.s.dispose();
                this.onError(e2);
                return;
            }
            this.value = u2;
            a2.onNext(u2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }
}

