/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableRetryWhen$RepeatWhenObserver;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;

public final class ObservableRetryWhen<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Observable<Throwable>, ? extends ObservableSource<?>> handler;

    public ObservableRetryWhen(ObservableSource<T> source, Function<? super Observable<Throwable>, ? extends ObservableSource<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        ObservableSource<?> other;
        Subject<Throwable> signaller = PublishSubject.create().toSerialized();
        try {
            other = ObjectHelper.requireNonNull(this.handler.apply(signaller), "The handler returned a null ObservableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        ObservableRetryWhen$RepeatWhenObserver<T> parent = new ObservableRetryWhen$RepeatWhenObserver<T>(observer, signaller, this.source);
        observer.onSubscribe(parent);
        other.subscribe(parent.inner);
        parent.subscribeNext();
    }
}

