/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.internal.operators.observable.ObservableReplay$InnerDisposable;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplayBuffer;
import io.reactivex.internal.util.NotificationLite;
import java.util.ArrayList;

final class ObservableReplay$UnboundedReplayBuffer<T>
extends ArrayList<Object>
implements ObservableReplay$ReplayBuffer<T> {
    private static final long serialVersionUID = 7063189396499112664L;
    volatile int size;

    ObservableReplay$UnboundedReplayBuffer(int capacityHint) {
        super(capacityHint);
    }

    @Override
    public void next(T value) {
        this.add(NotificationLite.next(value));
        ++this.size;
    }

    @Override
    public void error(Throwable e2) {
        this.add(NotificationLite.error(e2));
        ++this.size;
    }

    @Override
    public void complete() {
        this.add(NotificationLite.complete());
        ++this.size;
    }

    @Override
    public void replay(ObservableReplay$InnerDisposable<T> output) {
        if (output.getAndIncrement() != 0) {
            return;
        }
        Observer child = output.child;
        int missed = 1;
        do {
            int destinationIndex;
            if (output.isDisposed()) {
                return;
            }
            int sourceIndex = this.size;
            Integer destinationIndexObject = (Integer)output.index();
            int n2 = destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
            while (destinationIndex < sourceIndex) {
                Object o2 = this.get(destinationIndex);
                if (NotificationLite.accept(o2, child)) {
                    return;
                }
                if (output.isDisposed()) {
                    return;
                }
                ++destinationIndex;
            }
            output.index = destinationIndex;
        } while ((missed = output.addAndGet(-missed)) != 0);
    }
}

