/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableReplay$InnerDisposable;
import io.reactivex.internal.operators.observable.ObservableReplay$ReplayBuffer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableReplay$ReplayObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -533785617179540163L;
    final ObservableReplay$ReplayBuffer<T> buffer;
    boolean done;
    static final ObservableReplay$InnerDisposable[] EMPTY = new ObservableReplay$InnerDisposable[0];
    static final ObservableReplay$InnerDisposable[] TERMINATED = new ObservableReplay$InnerDisposable[0];
    final AtomicReference<ObservableReplay$InnerDisposable[]> observers;
    final AtomicBoolean shouldConnect;

    ObservableReplay$ReplayObserver(ObservableReplay$ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.observers = new AtomicReference<ObservableReplay$InnerDisposable[]>(EMPTY);
        this.shouldConnect = new AtomicBoolean();
    }

    @Override
    public boolean isDisposed() {
        return this.observers.get() == TERMINATED;
    }

    @Override
    public void dispose() {
        this.observers.set(TERMINATED);
        DisposableHelper.dispose(this);
    }

    boolean add(ObservableReplay$InnerDisposable<T> producer) {
        ObservableReplay$InnerDisposable[] u2;
        ObservableReplay$InnerDisposable[] c2;
        do {
            if ((c2 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int len = c2.length;
            u2 = new ObservableReplay$InnerDisposable[len + 1];
            System.arraycopy(c2, 0, u2, 0, len);
            u2[len] = producer;
        } while (!this.observers.compareAndSet(c2, u2));
        return true;
    }

    void remove(ObservableReplay$InnerDisposable<T> producer) {
        ObservableReplay$InnerDisposable[] u2;
        ObservableReplay$InnerDisposable[] c2;
        do {
            int len;
            if ((len = (c2 = this.observers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (!c2[i2].equals(producer)) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                u2 = EMPTY;
                continue;
            }
            u2 = new ObservableReplay$InnerDisposable[len - 1];
            System.arraycopy(c2, 0, u2, 0, j2);
            System.arraycopy(c2, j2 + 1, u2, j2, len - j2 - 1);
        } while (!this.observers.compareAndSet(c2, u2));
    }

    @Override
    public void onSubscribe(Disposable p2) {
        if (DisposableHelper.setOnce(this, p2)) {
            this.replay();
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done) {
            this.buffer.next(t2);
            this.replay();
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (!this.done) {
            this.done = true;
            this.buffer.error(e2);
            this.replayFinal();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.buffer.complete();
            this.replayFinal();
        }
    }

    void replay() {
        ObservableReplay$InnerDisposable[] a2;
        for (ObservableReplay$InnerDisposable rp2 : a2 = this.observers.get()) {
            this.buffer.replay(rp2);
        }
    }

    void replayFinal() {
        ObservableReplay$InnerDisposable[] a2;
        for (ObservableReplay$InnerDisposable rp2 : a2 = this.observers.getAndSet(TERMINATED)) {
            this.buffer.replay(rp2);
        }
    }
}

