/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableRepeatWhen$RepeatWhenObserver;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;

public final class ObservableRepeatWhen<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Observable<Object>, ? extends ObservableSource<?>> handler;

    public ObservableRepeatWhen(ObservableSource<T> source, Function<? super Observable<Object>, ? extends ObservableSource<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        ObservableSource<?> other;
        Subject<Object> signaller = PublishSubject.create().toSerialized();
        try {
            other = ObjectHelper.requireNonNull(this.handler.apply(signaller), "The handler returned a null ObservableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        ObservableRepeatWhen$RepeatWhenObserver<T> parent = new ObservableRepeatWhen$RepeatWhenObserver<T>(observer, signaller, this.source);
        observer.onSubscribe(parent);
        other.subscribe(parent.inner);
        parent.subscribeNext();
    }
}

