/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableRepeat$RepeatObserver<T>
extends AtomicInteger
implements Observer<T> {
    private static final long serialVersionUID = -7098360935104053232L;
    final Observer<? super T> actual;
    final SequentialDisposable sd;
    final ObservableSource<? extends T> source;
    long remaining;

    ObservableRepeat$RepeatObserver(Observer<? super T> actual, long count, SequentialDisposable sd2, ObservableSource<? extends T> source) {
        this.actual = actual;
        this.sd = sd2;
        this.source = source;
        this.remaining = count;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        this.sd.replace(s2);
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        long r2 = this.remaining;
        if (r2 != Long.MAX_VALUE) {
            this.remaining = r2 - 1L;
        }
        if (r2 != 0L) {
            this.subscribeNext();
        } else {
            this.actual.onComplete();
        }
    }

    void subscribeNext() {
        block2: {
            if (this.getAndIncrement() != 0) break block2;
            int missed = 1;
            do {
                if (this.sd.isDisposed()) {
                    return;
                }
                this.source.subscribe(this);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

