/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableRefCount$ConnectionObserver;
import io.reactivex.internal.operators.observable.ObservableRefCount$DisposeConsumer;
import io.reactivex.internal.operators.observable.ObservableRefCount$DisposeTask;
import io.reactivex.observables.ConnectableObservable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class ObservableRefCount<T>
extends AbstractObservableWithUpstream<T, T> {
    final ConnectableObservable<? extends T> source;
    volatile CompositeDisposable baseDisposable = new CompositeDisposable();
    final AtomicInteger subscriptionCount = new AtomicInteger();
    final ReentrantLock lock = new ReentrantLock();

    public ObservableRefCount(ConnectableObservable<T> source) {
        super(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Observer<? super T> subscriber) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber, this.baseDisposable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Consumer<Disposable> onSubscribe(Observer<? super T> observer, AtomicBoolean writeLocked) {
        return new ObservableRefCount$DisposeConsumer(this, observer, writeLocked);
    }

    void doSubscribe(Observer<? super T> observer, CompositeDisposable currentBase) {
        Disposable d2 = this.disconnect(currentBase);
        ObservableRefCount$ConnectionObserver s2 = new ObservableRefCount$ConnectionObserver(this, observer, currentBase, d2);
        observer.onSubscribe(s2);
        this.source.subscribe(s2);
    }

    private Disposable disconnect(CompositeDisposable current) {
        return Disposables.fromRunnable(new ObservableRefCount$DisposeTask(this, current));
    }
}

