/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.internal.operators.observable.ObservablePublish$PublishObserver;
import io.reactivex.internal.operators.observable.ObservablePublish$PublishSource;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublish<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<ObservablePublish$PublishObserver<T>> current;
    final ObservableSource<T> onSubscribe;

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source) {
        AtomicReference curr = new AtomicReference();
        ObservablePublish$PublishSource onSubscribe = new ObservablePublish$PublishSource(curr);
        return RxJavaPlugins.onAssembly(new ObservablePublish(onSubscribe, source, curr));
    }

    private ObservablePublish(ObservableSource<T> onSubscribe, ObservableSource<T> source, AtomicReference<ObservablePublish$PublishObserver<T>> current) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        this.onSubscribe.subscribe(observer);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        ObservablePublish$PublishObserver<T> ps2;
        while ((ps2 = this.current.get()) == null || ps2.isDisposed()) {
            ObservablePublish$PublishObserver<T> u2 = new ObservablePublish$PublishObserver<T>(this.current);
            if (!this.current.compareAndSet(ps2, u2)) continue;
            ps2 = u2;
            break;
        }
        boolean doConnect = !ps2.shouldConnect.get() && ps2.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        if (doConnect) {
            this.source.subscribe(ps2);
        }
    }
}

