/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;

final class ObservableMapNotification$MapNotificationObserver<T, R>
implements Observer<T>,
Disposable {
    final Observer<? super ObservableSource<? extends R>> actual;
    final Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper;
    final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper;
    final Callable<? extends ObservableSource<? extends R>> onCompleteSupplier;
    Disposable s;

    ObservableMapNotification$MapNotificationObserver(Observer<? super ObservableSource<? extends R>> actual, Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, Callable<? extends ObservableSource<? extends R>> onCompleteSupplier) {
        this.actual = actual;
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        ObservableSource<? extends R> p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.onNextMapper.apply(t2), "The onNext ObservableSource returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            return;
        }
        this.actual.onNext(p2);
    }

    @Override
    public void onError(Throwable t2) {
        ObservableSource<? extends R> p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.onErrorMapper.apply(t2), "The onError ObservableSource returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            return;
        }
        this.actual.onNext(p2);
        this.actual.onComplete();
    }

    @Override
    public void onComplete() {
        ObservableSource<? extends R> p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.onCompleteSupplier.call(), "The onComplete ObservableSource returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            return;
        }
        this.actual.onNext(p2);
        this.actual.onComplete();
    }
}

