/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableOperator;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableLift<R, T>
extends AbstractObservableWithUpstream<T, R> {
    final ObservableOperator<? extends R, ? super T> operator;

    public ObservableLift(ObservableSource<T> source, ObservableOperator<? extends R, ? super T> operator) {
        super(source);
        this.operator = operator;
    }

    @Override
    public void subscribeActual(Observer<? super R> s2) {
        Observer<? super T> observer;
        try {
            observer = ObjectHelper.requireNonNull(this.operator.apply(s2), "Operator " + this.operator + " returned a null Observer");
        }
        catch (NullPointerException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(e3);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e3);
            throw npe;
        }
        this.source.subscribe(observer);
    }
}

