/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.ObservableGroupBy$GroupByObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableGroupBy$State<T, K>
extends AtomicInteger
implements ObservableSource<T>,
Disposable {
    private static final long serialVersionUID = -3852313036005250360L;
    final K key;
    final SpscLinkedArrayQueue<T> queue;
    final ObservableGroupBy$GroupByObserver<?, K, T> parent;
    final boolean delayError;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean cancelled = new AtomicBoolean();
    final AtomicBoolean once = new AtomicBoolean();
    final AtomicReference<Observer<? super T>> actual = new AtomicReference();

    ObservableGroupBy$State(int bufferSize, ObservableGroupBy$GroupByObserver<?, K, T> parent, K key, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.parent = parent;
        this.key = key;
        this.delayError = delayError;
    }

    @Override
    public void dispose() {
        if (this.cancelled.compareAndSet(false, true) && this.getAndIncrement() == 0) {
            this.actual.lazySet(null);
            this.parent.cancel(this.key);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled.get();
    }

    @Override
    public void subscribe(Observer<? super T> s2) {
        if (this.once.compareAndSet(false, true)) {
            s2.onSubscribe(this);
            this.actual.lazySet(s2);
            if (this.cancelled.get()) {
                this.actual.lazySet(null);
            } else {
                this.drain();
            }
        } else {
            EmptyDisposable.error((Throwable)new IllegalStateException("Only one Observer allowed!"), s2);
        }
    }

    public void onNext(T t2) {
        this.queue.offer(t2);
        this.drain();
    }

    public void onError(Throwable e2) {
        this.error = e2;
        this.done = true;
        this.drain();
    }

    public void onComplete() {
        this.done = true;
        this.drain();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        boolean delayError = this.delayError;
        Observer<T> a2 = this.actual.get();
        while (true) {
            if (a2 != null) {
                while (true) {
                    boolean empty;
                    boolean d2 = this.done;
                    T v2 = q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (this.checkTerminated(d2, empty, a2, delayError)) {
                        return;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                }
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
            if (a2 != null) continue;
            a2 = this.actual.get();
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Observer<? super T> a2, boolean delayError) {
        if (this.cancelled.get()) {
            this.queue.clear();
            this.parent.cancel(this.key);
            this.actual.lazySet(null);
            return true;
        }
        if (d2) {
            if (delayError) {
                if (empty) {
                    Throwable e2 = this.error;
                    this.actual.lazySet(null);
                    if (e2 != null) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e3 = this.error;
                if (e3 != null) {
                    this.queue.clear();
                    this.actual.lazySet(null);
                    a2.onError(e3);
                    return true;
                }
                if (empty) {
                    this.actual.lazySet(null);
                    a2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }
}

