/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableGroupBy$GroupedUnicast;
import io.reactivex.observables.GroupedObservable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableGroupBy$GroupByObserver<T, K, V>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -3688291656102519502L;
    final Observer<? super GroupedObservable<K, V>> actual;
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Map<Object, ObservableGroupBy$GroupedUnicast<K, V>> groups;
    static final Object NULL_KEY = new Object();
    Disposable s;
    final AtomicBoolean cancelled = new AtomicBoolean();

    public ObservableGroupBy$GroupByObserver(Observer<? super GroupedObservable<K, V>> actual, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError) {
        this.actual = actual;
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
        this.groups = new ConcurrentHashMap<Object, ObservableGroupBy$GroupedUnicast<K, V>>();
        this.lazySet(1);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        V v2;
        K key;
        try {
            key = this.keySelector.apply(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.dispose();
            this.onError(e2);
            return;
        }
        Object mapKey = key != null ? key : NULL_KEY;
        ObservableGroupBy$GroupedUnicast<K, Object> group = this.groups.get(mapKey);
        if (group == null) {
            if (this.cancelled.get()) {
                return;
            }
            group = ObservableGroupBy$GroupedUnicast.createWith(key, this.bufferSize, this, this.delayError);
            this.groups.put(mapKey, group);
            this.getAndIncrement();
            this.actual.onNext(group);
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.valueSelector.apply(t2), "The value supplied is null");
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            this.s.dispose();
            this.onError(e3);
            return;
        }
        group.onNext(v2);
    }

    @Override
    public void onError(Throwable t2) {
        ArrayList<ObservableGroupBy$GroupedUnicast<K, V>> list = new ArrayList<ObservableGroupBy$GroupedUnicast<K, V>>(this.groups.values());
        this.groups.clear();
        for (ObservableGroupBy$GroupedUnicast observableGroupBy$GroupedUnicast : list) {
            observableGroupBy$GroupedUnicast.onError(t2);
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        ArrayList<ObservableGroupBy$GroupedUnicast<K, V>> list = new ArrayList<ObservableGroupBy$GroupedUnicast<K, V>>(this.groups.values());
        this.groups.clear();
        for (ObservableGroupBy$GroupedUnicast observableGroupBy$GroupedUnicast : list) {
            observableGroupBy$GroupedUnicast.onComplete();
        }
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        if (this.cancelled.compareAndSet(false, true) && this.decrementAndGet() == 0) {
            this.s.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled.get();
    }

    public void cancel(K key) {
        Object mapKey = key != null ? key : NULL_KEY;
        this.groups.remove(mapKey);
        if (this.decrementAndGet() == 0) {
            this.s.dispose();
        }
    }
}

