/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Emitter;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.ObservableGenerate$GeneratorDisposable;
import java.util.concurrent.Callable;

public final class ObservableGenerate<T, S>
extends Observable<T> {
    final Callable<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public ObservableGenerate(Callable<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        S state;
        try {
            state = this.stateSupplier.call();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptyDisposable.error(e2, s2);
            return;
        }
        ObservableGenerate$GeneratorDisposable<T, S> gd2 = new ObservableGenerate$GeneratorDisposable<T, S>(s2, this.generator, this.disposeState, state);
        s2.onSubscribe(gd2);
        gd2.run();
    }
}

