/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicQueueDisposable;
import java.util.Iterator;

final class ObservableFromIterable$FromIterableDisposable<T>
extends BasicQueueDisposable<T> {
    final Observer<? super T> actual;
    final Iterator<? extends T> it;
    volatile boolean disposed;
    boolean fusionMode;
    boolean done;
    boolean checkNext;

    ObservableFromIterable$FromIterableDisposable(Observer<? super T> actual, Iterator<? extends T> it2) {
        this.actual = actual;
        this.it = it2;
    }

    void run() {
        boolean hasNext;
        do {
            T v2;
            if (this.isDisposed()) {
                return;
            }
            try {
                v2 = ObjectHelper.requireNonNull(this.it.next(), "The iterator returned a null value");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.actual.onError(e2);
                return;
            }
            this.actual.onNext(v2);
            if (this.isDisposed()) {
                return;
            }
            try {
                hasNext = this.it.hasNext();
            }
            catch (Throwable e3) {
                Exceptions.throwIfFatal(e3);
                this.actual.onError(e3);
                return;
            }
        } while (hasNext);
        if (!this.isDisposed()) {
            this.actual.onComplete();
        }
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 1) != 0) {
            this.fusionMode = true;
            return 1;
        }
        return 0;
    }

    @Override
    @Nullable
    public T poll() {
        if (this.done) {
            return null;
        }
        if (this.checkNext) {
            if (!this.it.hasNext()) {
                this.done = true;
                return null;
            }
        } else {
            this.checkNext = true;
        }
        return ObjectHelper.requireNonNull(this.it.next(), "The iterator returned a null value");
    }

    @Override
    public boolean isEmpty() {
        return this.done;
    }

    @Override
    public void clear() {
        this.done = true;
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

