/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.DeferredScalarDisposable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ObservableFromFuture<T>
extends Observable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public ObservableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        DeferredScalarDisposable<T> d2 = new DeferredScalarDisposable<T>(s2);
        s2.onSubscribe(d2);
        if (!d2.isDisposed()) {
            T v2;
            try {
                v2 = ObjectHelper.requireNonNull(this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get(), "Future returned null");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                if (!d2.isDisposed()) {
                    s2.onError(ex2);
                }
                return;
            }
            d2.complete(v2);
        }
    }
}

