/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicQueueDisposable;

final class ObservableFromArray$FromArrayDisposable<T>
extends BasicQueueDisposable<T> {
    final Observer<? super T> actual;
    final T[] array;
    int index;
    boolean fusionMode;
    volatile boolean disposed;

    ObservableFromArray$FromArrayDisposable(Observer<? super T> actual, T[] array) {
        this.actual = actual;
        this.array = array;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 1) != 0) {
            this.fusionMode = true;
            return 1;
        }
        return 0;
    }

    @Override
    @Nullable
    public T poll() {
        int i2 = this.index;
        T[] a2 = this.array;
        if (i2 != a2.length) {
            this.index = i2 + 1;
            return ObjectHelper.requireNonNull(a2[i2], "The array element is null");
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.index == this.array.length;
    }

    @Override
    public void clear() {
        this.index = this.array.length;
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    void run() {
        T[] a2 = this.array;
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2 && !this.isDisposed(); ++i2) {
            T value = a2[i2];
            if (value == null) {
                this.actual.onError(new NullPointerException("The " + i2 + "th element is null"));
                return;
            }
            this.actual.onNext(value);
        }
        if (!this.isDisposed()) {
            this.actual.onComplete();
        }
    }
}

