/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;

final class ObservableFlattenIterable$FlattenIterableObserver<T, R>
implements Observer<T>,
Disposable {
    final Observer<? super R> actual;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    Disposable d;

    ObservableFlattenIterable$FlattenIterableObserver(Observer<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.actual = actual;
        this.mapper = mapper;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T value) {
        Iterator<R> it2;
        if (this.d == DisposableHelper.DISPOSED) {
            return;
        }
        try {
            it2 = this.mapper.apply(value).iterator();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.d.dispose();
            this.onError(ex2);
            return;
        }
        Observer<R> a2 = this.actual;
        while (true) {
            R v2;
            boolean b2;
            try {
                b2 = it2.hasNext();
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                this.d.dispose();
                this.onError(ex3);
                return;
            }
            if (!b2) break;
            try {
                v2 = ObjectHelper.requireNonNull(it2.next(), "The iterator returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.d.dispose();
                this.onError(ex4);
                return;
            }
            a2.onNext(v2);
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (this.d == DisposableHelper.DISPOSED) {
            RxJavaPlugins.onError(e2);
            return;
        }
        this.d = DisposableHelper.DISPOSED;
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        if (this.d == DisposableHelper.DISPOSED) {
            return;
        }
        this.d = DisposableHelper.DISPOSED;
        this.actual.onComplete();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void dispose() {
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
    }
}

