/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.CompletableSource;
import io.reactivex.Observer;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.reactivex.internal.operators.observable.ObservableFlatMapCompletable$FlatMapCompletableMainObserver$InnerObserver;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableFlatMapCompletable$FlatMapCompletableMainObserver<T>
extends BasicIntQueueDisposable<T>
implements Observer<T> {
    private static final long serialVersionUID = 8443155186132538303L;
    final Observer<? super T> actual;
    final AtomicThrowable errors;
    final Function<? super T, ? extends CompletableSource> mapper;
    final boolean delayErrors;
    final CompositeDisposable set;
    Disposable d;
    volatile boolean disposed;

    ObservableFlatMapCompletable$FlatMapCompletableMainObserver(Observer<? super T> observer, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
        this.actual = observer;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.errors = new AtomicThrowable();
        this.set = new CompositeDisposable();
        this.lazySet(1);
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T value) {
        CompletableSource cs2;
        try {
            cs2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.d.dispose();
            this.onError(ex2);
            return;
        }
        this.getAndIncrement();
        ObservableFlatMapCompletable$FlatMapCompletableMainObserver$InnerObserver inner = new ObservableFlatMapCompletable$FlatMapCompletableMainObserver$InnerObserver(this);
        if (!this.disposed && this.set.add(inner)) {
            cs2.subscribe(inner);
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (this.errors.addThrowable(e2)) {
            if (this.delayErrors) {
                if (this.decrementAndGet() == 0) {
                    Throwable ex2 = this.errors.terminate();
                    this.actual.onError(ex2);
                }
            } else {
                this.dispose();
                if (this.getAndSet(0) > 0) {
                    Throwable ex3 = this.errors.terminate();
                    this.actual.onError(ex3);
                }
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (this.decrementAndGet() == 0) {
            Throwable ex2 = this.errors.terminate();
            if (ex2 != null) {
                this.actual.onError(ex2);
            } else {
                this.actual.onComplete();
            }
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.d.dispose();
        this.set.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    @Nullable
    public T poll() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public int requestFusion(int mode) {
        return mode & 2;
    }

    void innerComplete(ObservableFlatMapCompletable$FlatMapCompletableMainObserver$InnerObserver inner) {
        this.set.delete(inner);
        this.onComplete();
    }

    void innerError(ObservableFlatMapCompletable$FlatMapCompletableMainObserver$InnerObserver inner, Throwable e2) {
        this.set.delete(inner);
        this.onError(e2);
    }
}

