/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.ObservableFlatMap$MergeObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableFlatMap$InnerObserver<T, U>
extends AtomicReference<Disposable>
implements Observer<U> {
    private static final long serialVersionUID = -4606175640614850599L;
    final long id;
    final ObservableFlatMap$MergeObserver<T, U> parent;
    volatile boolean done;
    volatile SimpleQueue<U> queue;
    int fusionMode;

    ObservableFlatMap$InnerObserver(ObservableFlatMap$MergeObserver<T, U> parent, long id2) {
        this.id = id2;
        this.parent = parent;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.setOnce(this, s2) && s2 instanceof QueueDisposable) {
            QueueDisposable qd2 = (QueueDisposable)s2;
            int m2 = qd2.requestFusion(7);
            if (m2 == 1) {
                this.fusionMode = m2;
                this.queue = qd2;
                this.done = true;
                this.parent.drain();
                return;
            }
            if (m2 == 2) {
                this.fusionMode = m2;
                this.queue = qd2;
            }
        }
    }

    @Override
    public void onNext(U t2) {
        if (this.fusionMode == 0) {
            this.parent.tryEmit(t2, this);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.parent.errors.addThrowable(t2)) {
            if (!this.parent.delayErrors) {
                this.parent.disposeAll();
            }
            this.done = true;
            this.parent.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.parent.drain();
    }

    public void dispose() {
        DisposableHelper.dispose(this);
    }
}

