/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;

final class ObservableElementAt$ElementAtObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final long index;
    final T defaultValue;
    final boolean errorOnFewer;
    Disposable s;
    long count;
    boolean done;

    ObservableElementAt$ElementAtObserver(Observer<? super T> actual, long index, T defaultValue, boolean errorOnFewer) {
        this.actual = actual;
        this.index = index;
        this.defaultValue = defaultValue;
        this.errorOnFewer = errorOnFewer;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        long c2 = this.count;
        if (c2 == this.index) {
            this.done = true;
            this.s.dispose();
            this.actual.onNext(t2);
            this.actual.onComplete();
            return;
        }
        this.count = c2 + 1L;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            T v2 = this.defaultValue;
            if (v2 == null && this.errorOnFewer) {
                this.actual.onError(new NoSuchElementException());
            } else {
                if (v2 != null) {
                    this.actual.onNext(v2);
                }
                this.actual.onComplete();
            }
        }
    }
}

