/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.ObservableDebounceTimed$DebounceEmitter;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableDebounceTimed$DebounceTimedObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    Disposable s;
    final AtomicReference<Disposable> timer = new AtomicReference();
    volatile long index;
    boolean done;

    ObservableDebounceTimed$DebounceTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        ObservableDebounceTimed$DebounceEmitter<T> de2;
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        Disposable d2 = this.timer.get();
        if (d2 != null) {
            d2.dispose();
        }
        if (this.timer.compareAndSet(d2, de2 = new ObservableDebounceTimed$DebounceEmitter<T>(t2, idx, this))) {
            d2 = this.worker.schedule(de2, this.timeout, this.unit);
            de2.setResource(d2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
        this.worker.dispose();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Disposable d2 = this.timer.get();
        if (d2 != DisposableHelper.DISPOSED) {
            ObservableDebounceTimed$DebounceEmitter de2 = (ObservableDebounceTimed$DebounceEmitter)d2;
            if (de2 != null) {
                de2.run();
            }
            this.actual.onComplete();
            this.worker.dispose();
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
        this.worker.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.worker.isDisposed();
    }

    void emit(long idx, T t2, ObservableDebounceTimed$DebounceEmitter<T> emitter) {
        if (idx == this.index) {
            this.actual.onNext(t2);
            emitter.dispose();
        }
    }
}

