/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableDebounce$DebounceObserver$DebounceInnerObserver;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableDebounce$DebounceObserver<T, U>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final Function<? super T, ? extends ObservableSource<U>> debounceSelector;
    Disposable s;
    final AtomicReference<Disposable> debouncer = new AtomicReference();
    volatile long index;
    boolean done;

    ObservableDebounce$DebounceObserver(Observer<? super T> actual, Function<? super T, ? extends ObservableSource<U>> debounceSelector) {
        this.actual = actual;
        this.debounceSelector = debounceSelector;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        ObservableSource<U> p2;
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        Disposable d2 = this.debouncer.get();
        if (d2 != null) {
            d2.dispose();
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.debounceSelector.apply(t2), "The ObservableSource supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.dispose();
            this.actual.onError(e2);
            return;
        }
        ObservableDebounce$DebounceObserver$DebounceInnerObserver dis = new ObservableDebounce$DebounceObserver$DebounceInnerObserver(this, idx, t2);
        if (this.debouncer.compareAndSet(d2, dis)) {
            p2.subscribe(dis);
        }
    }

    @Override
    public void onError(Throwable t2) {
        DisposableHelper.dispose(this.debouncer);
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Disposable d2 = this.debouncer.get();
        if (d2 != DisposableHelper.DISPOSED) {
            ObservableDebounce$DebounceObserver$DebounceInnerObserver dis = (ObservableDebounce$DebounceObserver$DebounceInnerObserver)d2;
            dis.emit();
            DisposableHelper.dispose(this.debouncer);
            this.actual.onComplete();
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
        DisposableHelper.dispose(this.debouncer);
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    void emit(long idx, T value) {
        if (idx == this.index) {
            this.actual.onNext(value);
        }
    }
}

