/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableEmitter;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableCreate$SerializedEmitter<T>
extends AtomicInteger
implements ObservableEmitter<T> {
    private static final long serialVersionUID = 4883307006032401862L;
    final ObservableEmitter<T> emitter;
    final AtomicThrowable error;
    final SpscLinkedArrayQueue<T> queue;
    volatile boolean done;

    ObservableCreate$SerializedEmitter(ObservableEmitter<T> emitter) {
        this.emitter = emitter;
        this.error = new AtomicThrowable();
        this.queue = new SpscLinkedArrayQueue(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        if (this.emitter.isDisposed() || this.done) {
            return;
        }
        if (t2 == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            this.emitter.onNext(t2);
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SpscLinkedArrayQueue<T> q2;
            SpscLinkedArrayQueue<T> spscLinkedArrayQueue = q2 = this.queue;
            synchronized (spscLinkedArrayQueue) {
                q2.offer(t2);
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.tryOnError(t2)) {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public boolean tryOnError(Throwable t2) {
        if (this.emitter.isDisposed() || this.done) {
            return false;
        }
        if (t2 == null) {
            t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.error.addThrowable(t2)) {
            this.done = true;
            this.drain();
            return true;
        }
        return false;
    }

    @Override
    public void onComplete() {
        if (this.emitter.isDisposed() || this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    void drain() {
        if (this.getAndIncrement() == 0) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        ObservableEmitter<T> e2 = this.emitter;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        AtomicThrowable error = this.error;
        int missed = 1;
        while (true) {
            boolean empty;
            if (e2.isDisposed()) {
                q2.clear();
                return;
            }
            if (error.get() != null) {
                q2.clear();
                e2.onError(error.terminate());
                return;
            }
            boolean d2 = this.done;
            T v2 = q2.poll();
            boolean bl2 = empty = v2 == null;
            if (d2 && empty) {
                e2.onComplete();
                return;
            }
            if (!empty) {
                e2.onNext(v2);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public void setDisposable(Disposable s2) {
        this.emitter.setDisposable(s2);
    }

    @Override
    public void setCancellable(Cancellable c2) {
        this.emitter.setCancellable(c2);
    }

    @Override
    public boolean isDisposed() {
        return this.emitter.isDisposed();
    }

    @Override
    public ObservableEmitter<T> serialize() {
        return this;
    }
}

