/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.ObservableConcatMapCompletable$SourceObserver$InnerObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableConcatMapCompletable$SourceObserver<T>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = 6893587405571511048L;
    final CompletableObserver actual;
    final Function<? super T, ? extends CompletableSource> mapper;
    final ObservableConcatMapCompletable$SourceObserver$InnerObserver inner;
    final int bufferSize;
    SimpleQueue<T> queue;
    Disposable s;
    volatile boolean active;
    volatile boolean disposed;
    volatile boolean done;
    int sourceMode;

    ObservableConcatMapCompletable$SourceObserver(CompletableObserver actual, Function<? super T, ? extends CompletableSource> mapper, int bufferSize) {
        this.actual = actual;
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.inner = new ObservableConcatMapCompletable$SourceObserver$InnerObserver(actual, this);
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueDisposable) {
                QueueDisposable qd2 = (QueueDisposable)s2;
                int m2 = qd2.requestFusion(3);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qd2;
                    this.done = true;
                    this.actual.onSubscribe(this);
                    this.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qd2;
                    this.actual.onSubscribe(this);
                    return;
                }
            }
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.sourceMode == 0) {
            this.queue.offer(t2);
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.dispose();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    void innerComplete() {
        this.active = false;
        this.drain();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.inner.dispose();
        this.s.dispose();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        do {
            CompletableSource c2;
            boolean empty;
            T t2;
            if (this.disposed) {
                this.queue.clear();
                return;
            }
            if (this.active) continue;
            boolean d2 = this.done;
            try {
                t2 = this.queue.poll();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.dispose();
                this.queue.clear();
                this.actual.onError(ex2);
                return;
            }
            boolean bl2 = empty = t2 == null;
            if (d2 && empty) {
                this.disposed = true;
                this.actual.onComplete();
                return;
            }
            if (empty) continue;
            try {
                c2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex3) {
                Exceptions.throwIfFatal(ex3);
                this.dispose();
                this.queue.clear();
                this.actual.onError(ex3);
                return;
            }
            this.active = true;
            c2.subscribe(this.inner);
        } while (this.decrementAndGet() != 0);
    }
}

