/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableConcatMap$ConcatMapDelayErrorObserver;
import io.reactivex.internal.operators.observable.ObservableConcatMap$SourceObserver;
import io.reactivex.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.observers.SerializedObserver;

public final class ObservableConcatMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final int bufferSize;
    final ErrorMode delayErrors;

    public ObservableConcatMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize, ErrorMode delayErrors) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.bufferSize = Math.max(8, bufferSize);
    }

    @Override
    public void subscribeActual(Observer<? super U> s2) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, s2, this.mapper)) {
            return;
        }
        if (this.delayErrors == ErrorMode.IMMEDIATE) {
            SerializedObserver<? super U> serial = new SerializedObserver<U>(s2);
            this.source.subscribe(new ObservableConcatMap$SourceObserver<T, U>(serial, this.mapper, this.bufferSize));
        } else {
            this.source.subscribe(new ObservableConcatMap$ConcatMapDelayErrorObserver<T, U>(s2, this.mapper, this.bufferSize, this.delayErrors == ErrorMode.END));
        }
    }
}

