/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.observable.ObservableCache$CacheState;
import io.reactivex.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicInteger;

final class ObservableCache$ReplayDisposable<T>
extends AtomicInteger
implements Disposable {
    private static final long serialVersionUID = 7058506693698832024L;
    final Observer<? super T> child;
    final ObservableCache$CacheState<T> state;
    Object[] currentBuffer;
    int currentIndexInBuffer;
    int index;
    volatile boolean cancelled;

    ObservableCache$ReplayDisposable(Observer<? super T> child, ObservableCache$CacheState<T> state) {
        this.child = child;
        this.state = state;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.state.removeChild(this);
        }
    }

    public void replay() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Observer<? super T> child = this.child;
        int missed = 1;
        do {
            int j2;
            if (this.cancelled) {
                return;
            }
            int s2 = this.state.size();
            if (s2 == 0) continue;
            Object[] b2 = this.currentBuffer;
            if (b2 == null) {
                this.currentBuffer = b2 = this.state.head();
            }
            int n2 = b2.length - 1;
            int k2 = this.currentIndexInBuffer;
            for (j2 = this.index; j2 < s2; ++j2) {
                Object o2;
                if (this.cancelled) {
                    return;
                }
                if (k2 == n2) {
                    b2 = (Object[])b2[n2];
                    k2 = 0;
                }
                if (NotificationLite.accept(o2 = b2[k2], child)) {
                    return;
                }
                ++k2;
            }
            if (this.cancelled) {
                return;
            }
            this.index = j2;
            this.currentIndexInBuffer = k2;
            this.currentBuffer = b2;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

