/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableBufferTimed$BufferSkipBoundedObserver$RemoveFromBuffer;
import io.reactivex.internal.operators.observable.ObservableBufferTimed$BufferSkipBoundedObserver$RemoveFromBufferEmit;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class ObservableBufferTimed$BufferSkipBoundedObserver<T, U extends Collection<? super T>>
extends QueueDrainObserver<T, U, U>
implements Disposable,
Runnable {
    final Callable<U> bufferSupplier;
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler$Worker w;
    final List<U> buffers;
    Disposable s;

    ObservableBufferTimed$BufferSkipBoundedObserver(Observer<? super U> actual, Callable<U> bufferSupplier, long timespan, long timeskip, TimeUnit unit, Scheduler$Worker w2) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.w = w2;
        this.buffers = new LinkedList<U>();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            Collection b2;
            this.s = s2;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                s2.dispose();
                EmptyDisposable.error(e2, this.actual);
                this.w.dispose();
                return;
            }
            this.buffers.add(b2);
            this.actual.onSubscribe(this);
            this.w.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
            this.w.schedule(new ObservableBufferTimed$BufferSkipBoundedObserver$RemoveFromBufferEmit(this, b2), this.timespan, this.unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        ObservableBufferTimed$BufferSkipBoundedObserver observableBufferTimed$BufferSkipBoundedObserver = this;
        synchronized (observableBufferTimed$BufferSkipBoundedObserver) {
            for (Collection b2 : this.buffers) {
                b2.add(t2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.done = true;
        this.clear();
        this.actual.onError(t2);
        this.w.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        ArrayList<U> bs2;
        ObservableBufferTimed$BufferSkipBoundedObserver observableBufferTimed$BufferSkipBoundedObserver = this;
        synchronized (observableBufferTimed$BufferSkipBoundedObserver) {
            bs2 = new ArrayList<U>(this.buffers);
            this.buffers.clear();
        }
        for (Collection b2 : bs2) {
            this.queue.offer(b2);
        }
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainLoop(this.queue, this.actual, false, this.w, this);
        }
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.clear();
            this.s.dispose();
            this.w.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        ObservableBufferTimed$BufferSkipBoundedObserver observableBufferTimed$BufferSkipBoundedObserver = this;
        synchronized (observableBufferTimed$BufferSkipBoundedObserver) {
            this.buffers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Collection b2;
        if (this.cancelled) {
            return;
        }
        try {
            b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            this.dispose();
            return;
        }
        ObservableBufferTimed$BufferSkipBoundedObserver observableBufferTimed$BufferSkipBoundedObserver = this;
        synchronized (observableBufferTimed$BufferSkipBoundedObserver) {
            if (this.cancelled) {
                return;
            }
            this.buffers.add(b2);
        }
        this.w.schedule(new ObservableBufferTimed$BufferSkipBoundedObserver$RemoveFromBuffer(this, b2), this.timespan, this.unit);
    }

    @Override
    public void accept(Observer<? super U> a2, U v2) {
        a2.onNext(v2);
    }

    static /* synthetic */ void access$000(ObservableBufferTimed$BufferSkipBoundedObserver x0, Object x1, boolean x2, Disposable x3) {
        x0.fastPathOrderedEmit(x1, x2, x3);
    }

    static /* synthetic */ void access$100(ObservableBufferTimed$BufferSkipBoundedObserver x0, Object x1, boolean x2, Disposable x3) {
        x0.fastPathOrderedEmit(x1, x2, x3);
    }
}

