/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.ObservableBufferExactBoundary$BufferBoundaryObserver;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.QueueDrainHelper;
import java.util.Collection;
import java.util.concurrent.Callable;

final class ObservableBufferExactBoundary$BufferExactBoundaryObserver<T, U extends Collection<? super T>, B>
extends QueueDrainObserver<T, U, U>
implements Observer<T>,
Disposable {
    final Callable<U> bufferSupplier;
    final ObservableSource<B> boundary;
    Disposable s;
    Disposable other;
    U buffer;

    ObservableBufferExactBoundary$BufferExactBoundaryObserver(Observer<? super U> actual, Callable<U> bufferSupplier, ObservableSource<B> boundary) {
        super(actual, new MpscLinkedQueue());
        this.bufferSupplier = bufferSupplier;
        this.boundary = boundary;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            ObservableBufferExactBoundary$BufferBoundaryObserver bs2;
            Collection b2;
            this.s = s2;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancelled = true;
                s2.dispose();
                EmptyDisposable.error(e2, this.actual);
                return;
            }
            this.buffer = b2;
            this.other = bs2 = new ObservableBufferExactBoundary$BufferBoundaryObserver(this);
            this.actual.onSubscribe(this);
            if (!this.cancelled) {
                this.boundary.subscribe(bs2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        ObservableBufferExactBoundary$BufferExactBoundaryObserver observableBufferExactBoundary$BufferExactBoundaryObserver = this;
        synchronized (observableBufferExactBoundary$BufferExactBoundaryObserver) {
            U b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            b2.add(t2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.dispose();
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        U b2;
        ObservableBufferExactBoundary$BufferExactBoundaryObserver observableBufferExactBoundary$BufferExactBoundaryObserver = this;
        synchronized (observableBufferExactBoundary$BufferExactBoundaryObserver) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = null;
        }
        this.queue.offer(b2);
        this.done = true;
        if (this.enter()) {
            QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
        }
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.other.dispose();
            this.s.dispose();
            if (this.enter()) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void next() {
        U b2;
        Collection next;
        try {
            next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.dispose();
            this.actual.onError(e2);
            return;
        }
        ObservableBufferExactBoundary$BufferExactBoundaryObserver observableBufferExactBoundary$BufferExactBoundaryObserver = this;
        synchronized (observableBufferExactBoundary$BufferExactBoundaryObserver) {
            b2 = this.buffer;
            if (b2 == null) {
                return;
            }
            this.buffer = next;
        }
        this.fastPathEmit(b2, false, this);
    }

    @Override
    public void accept(Observer<? super U> a2, U v2) {
        this.actual.onNext(v2);
    }
}

