/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.ObservableBufferBoundary$BufferBoundaryObserver$BufferOpenObserver;
import io.reactivex.internal.operators.observable.ObservableBufferBoundary$BufferCloseObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableBufferBoundary$BufferBoundaryObserver<T, C extends Collection<? super T>, Open, Close>
extends AtomicInteger
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -8466418554264089604L;
    final Observer<? super C> actual;
    final Callable<C> bufferSupplier;
    final ObservableSource<? extends Open> bufferOpen;
    final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;
    final CompositeDisposable observers;
    final AtomicReference<Disposable> upstream;
    final AtomicThrowable errors;
    volatile boolean done;
    final SpscLinkedArrayQueue<C> queue;
    volatile boolean cancelled;
    long index;
    Map<Long, C> buffers;

    ObservableBufferBoundary$BufferBoundaryObserver(Observer<? super C> actual, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Callable<C> bufferSupplier) {
        this.actual = actual;
        this.bufferSupplier = bufferSupplier;
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
        this.observers = new CompositeDisposable();
        this.upstream = new AtomicReference();
        this.buffers = new LinkedHashMap<Long, C>();
        this.errors = new AtomicThrowable();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.setOnce(this.upstream, s2)) {
            ObservableBufferBoundary$BufferBoundaryObserver$BufferOpenObserver open = new ObservableBufferBoundary$BufferBoundaryObserver$BufferOpenObserver(this);
            this.observers.add(open);
            this.bufferOpen.subscribe(open);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        ObservableBufferBoundary$BufferBoundaryObserver observableBufferBoundary$BufferBoundaryObserver = this;
        synchronized (observableBufferBoundary$BufferBoundaryObserver) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            for (Collection b2 : bufs.values()) {
                b2.add(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        if (this.errors.addThrowable(t2)) {
            this.observers.dispose();
            ObservableBufferBoundary$BufferBoundaryObserver observableBufferBoundary$BufferBoundaryObserver = this;
            synchronized (observableBufferBoundary$BufferBoundaryObserver) {
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        this.observers.dispose();
        ObservableBufferBoundary$BufferBoundaryObserver observableBufferBoundary$BufferBoundaryObserver = this;
        synchronized (observableBufferBoundary$BufferBoundaryObserver) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            for (Collection b2 : bufs.values()) {
                this.queue.offer(b2);
            }
            this.buffers = null;
        }
        this.done = true;
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (DisposableHelper.dispose(this.upstream)) {
            this.cancelled = true;
            this.observers.dispose();
            ObservableBufferBoundary$BufferBoundaryObserver observableBufferBoundary$BufferBoundaryObserver = this;
            synchronized (observableBufferBoundary$BufferBoundaryObserver) {
                this.buffers = null;
            }
            if (this.getAndIncrement() != 0) {
                this.queue.clear();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed(this.upstream.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(Open token) {
        ObservableSource<Close> p2;
        Collection buf;
        try {
            buf = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null Collection");
            p2 = ObjectHelper.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null ObservableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            DisposableHelper.dispose(this.upstream);
            this.onError(ex2);
            return;
        }
        long idx = this.index;
        this.index = idx + 1L;
        ObservableBufferBoundary$BufferBoundaryObserver observableBufferBoundary$BufferBoundaryObserver = this;
        synchronized (observableBufferBoundary$BufferBoundaryObserver) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            bufs.put(idx, buf);
        }
        ObservableBufferBoundary$BufferCloseObserver bc2 = new ObservableBufferBoundary$BufferCloseObserver(this, idx);
        this.observers.add(bc2);
        p2.subscribe(bc2);
    }

    void openComplete(ObservableBufferBoundary$BufferBoundaryObserver$BufferOpenObserver<Open> os2) {
        this.observers.delete(os2);
        if (this.observers.size() == 0) {
            DisposableHelper.dispose(this.upstream);
            this.done = true;
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ObservableBufferBoundary$BufferCloseObserver<T, C> closer, long idx) {
        this.observers.delete(closer);
        boolean makeDone = false;
        if (this.observers.size() == 0) {
            makeDone = true;
            DisposableHelper.dispose(this.upstream);
        }
        ObservableBufferBoundary$BufferBoundaryObserver observableBufferBoundary$BufferBoundaryObserver = this;
        synchronized (observableBufferBoundary$BufferBoundaryObserver) {
            Map<Long, C> bufs = this.buffers;
            if (bufs == null) {
                return;
            }
            this.queue.offer(this.buffers.remove(idx));
        }
        if (makeDone) {
            this.done = true;
        }
        this.drain();
    }

    void boundaryError(Disposable observer, Throwable ex2) {
        DisposableHelper.dispose(this.upstream);
        this.observers.delete(observer);
        this.onError(ex2);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Observer<C> a2 = this.actual;
        SpscLinkedArrayQueue<C> q2 = this.queue;
        while (true) {
            boolean empty;
            if (this.cancelled) {
                q2.clear();
                return;
            }
            boolean d2 = this.done;
            if (d2 && this.errors.get() != null) {
                q2.clear();
                Throwable ex2 = this.errors.terminate();
                a2.onError(ex2);
                return;
            }
            Collection v2 = (Collection)q2.poll();
            boolean bl2 = empty = v2 == null;
            if (d2 && empty) {
                a2.onComplete();
                return;
            }
            if (!empty) {
                a2.onNext(v2);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }
}

