/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

final class ObservableBuffer$BufferSkipObserver<T, U extends Collection<? super T>>
extends AtomicBoolean
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -8223395059921494546L;
    final Observer<? super U> actual;
    final int count;
    final int skip;
    final Callable<U> bufferSupplier;
    Disposable s;
    final ArrayDeque<U> buffers;
    long index;

    ObservableBuffer$BufferSkipObserver(Observer<? super U> actual, int count, int skip, Callable<U> bufferSupplier) {
        this.actual = actual;
        this.count = count;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
        this.buffers = new ArrayDeque();
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t2) {
        if (this.index++ % (long)this.skip == 0L) {
            Collection b2;
            try {
                b2 = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
            }
            catch (Throwable e2) {
                this.buffers.clear();
                this.s.dispose();
                this.actual.onError(e2);
                return;
            }
            this.buffers.offer(b2);
        }
        Iterator<U> it2 = this.buffers.iterator();
        while (it2.hasNext()) {
            Collection b3 = (Collection)it2.next();
            b3.add(t2);
            if (this.count > b3.size()) continue;
            it2.remove();
            this.actual.onNext(b3);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.buffers.clear();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        while (!this.buffers.isEmpty()) {
            this.actual.onNext(this.buffers.poll());
        }
        this.actual.onComplete();
    }
}

