/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.ObservableAmb$AmbCoordinator;

public final class ObservableAmb<T>
extends Observable<T> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;

    public ObservableAmb(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Observable[8];
            try {
                for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                    if (observableSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), s2);
                        return;
                    }
                    if (count == sources.length) {
                        ObservableSource[] b2 = new ObservableSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b2, 0, count);
                        sources = b2;
                    }
                    sources[count++] = observableSource;
                }
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                EmptyDisposable.error(e2, s2);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(s2);
            return;
        }
        if (count == 1) {
            sources[0].subscribe(s2);
            return;
        }
        ObservableAmb$AmbCoordinator<? extends T> ac2 = new ObservableAmb$AmbCoordinator<T>(s2, count);
        ac2.subscribe(sources);
    }
}

