/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class ObservableAll$AllObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super Boolean> actual;
    final Predicate<? super T> predicate;
    Disposable s;
    boolean done;

    ObservableAll$AllObserver(Observer<? super Boolean> actual, Predicate<? super T> predicate) {
        this.actual = actual;
        this.predicate = predicate;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        boolean b2;
        if (this.done) {
            return;
        }
        try {
            b2 = this.predicate.test(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.s.dispose();
            this.onError(e2);
            return;
        }
        if (!b2) {
            this.done = true;
            this.s.dispose();
            this.actual.onNext((Boolean)false);
            this.actual.onComplete();
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onNext((Boolean)true);
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }
}

