/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.MaybeUsing$UsingObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class MaybeUsing<T, D>
extends Maybe<T> {
    final Callable<? extends D> resourceSupplier;
    final Function<? super D, ? extends MaybeSource<? extends T>> sourceSupplier;
    final Consumer<? super D> resourceDisposer;
    final boolean eager;

    public MaybeUsing(Callable<? extends D> resourceSupplier, Function<? super D, ? extends MaybeSource<? extends T>> sourceSupplier, Consumer<? super D> resourceDisposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.resourceDisposer = resourceDisposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> observer) {
        MaybeSource<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            EmptyDisposable.error(ex2, observer);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null MaybeSource");
        }
        catch (Throwable ex3) {
            Exceptions.throwIfFatal(ex3);
            if (this.eager) {
                try {
                    this.resourceDisposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    EmptyDisposable.error((Throwable)new CompositeException(ex3, exc), observer);
                    return;
                }
            }
            EmptyDisposable.error(ex3, observer);
            if (!this.eager) {
                try {
                    this.resourceDisposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source.subscribe(new MaybeUsing$UsingObserver<T, D>(observer, resource, this.resourceDisposer, this.eager));
    }
}

