/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeUsing$UsingObserver<T, D>
extends AtomicReference<Object>
implements MaybeObserver<T>,
Disposable {
    private static final long serialVersionUID = -674404550052917487L;
    final MaybeObserver<? super T> actual;
    final Consumer<? super D> disposer;
    final boolean eager;
    Disposable d;

    MaybeUsing$UsingObserver(MaybeObserver<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
        super(resource);
        this.actual = actual;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void dispose() {
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
        this.disposeResourceAfter();
    }

    void disposeResourceAfter() {
        MaybeUsing$UsingObserver resource = this.getAndSet(this);
        if (resource != this) {
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaPlugins.onError(ex2);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.d = DisposableHelper.DISPOSED;
        if (this.eager) {
            MaybeUsing$UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.actual.onError(ex2);
                    return;
                }
            } else {
                return;
            }
        }
        this.actual.onSuccess(value);
        if (!this.eager) {
            this.disposeResourceAfter();
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.d = DisposableHelper.DISPOSED;
        if (this.eager) {
            MaybeUsing$UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    e2 = new CompositeException(e2, ex2);
                }
            } else {
                return;
            }
        }
        this.actual.onError(e2);
        if (!this.eager) {
            this.disposeResourceAfter();
        }
    }

    @Override
    public void onComplete() {
        this.d = DisposableHelper.DISPOSED;
        if (this.eager) {
            MaybeUsing$UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.actual.onError(ex2);
                    return;
                }
            } else {
                return;
            }
        }
        this.actual.onComplete();
        if (!this.eager) {
            this.disposeResourceAfter();
        }
    }
}

