/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.maybe.MaybeTimeoutPublisher$TimeoutFallbackMaybeObserver;
import io.reactivex.internal.operators.maybe.MaybeTimeoutPublisher$TimeoutOtherMaybeObserver;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

final class MaybeTimeoutPublisher$TimeoutMainMaybeObserver<T, U>
extends AtomicReference<Disposable>
implements MaybeObserver<T>,
Disposable {
    private static final long serialVersionUID = -5955289211445418871L;
    final MaybeObserver<? super T> actual;
    final MaybeTimeoutPublisher$TimeoutOtherMaybeObserver<T, U> other;
    final MaybeSource<? extends T> fallback;
    final MaybeTimeoutPublisher$TimeoutFallbackMaybeObserver<T> otherObserver;

    MaybeTimeoutPublisher$TimeoutMainMaybeObserver(MaybeObserver<? super T> actual, MaybeSource<? extends T> fallback) {
        this.actual = actual;
        this.other = new MaybeTimeoutPublisher$TimeoutOtherMaybeObserver(this);
        this.fallback = fallback;
        this.otherObserver = fallback != null ? new MaybeTimeoutPublisher$TimeoutFallbackMaybeObserver<T>(actual) : null;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
        SubscriptionHelper.cancel(this.other);
        MaybeTimeoutPublisher$TimeoutFallbackMaybeObserver<T> oo2 = this.otherObserver;
        if (oo2 != null) {
            DisposableHelper.dispose(oo2);
        }
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        DisposableHelper.setOnce(this, d2);
    }

    @Override
    public void onSuccess(T value) {
        SubscriptionHelper.cancel(this.other);
        if (this.getAndSet(DisposableHelper.DISPOSED) != DisposableHelper.DISPOSED) {
            this.actual.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e2) {
        SubscriptionHelper.cancel(this.other);
        if (this.getAndSet(DisposableHelper.DISPOSED) != DisposableHelper.DISPOSED) {
            this.actual.onError(e2);
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        SubscriptionHelper.cancel(this.other);
        if (this.getAndSet(DisposableHelper.DISPOSED) != DisposableHelper.DISPOSED) {
            this.actual.onComplete();
        }
    }

    public void otherError(Throwable e2) {
        if (DisposableHelper.dispose(this)) {
            this.actual.onError(e2);
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    public void otherComplete() {
        if (DisposableHelper.dispose(this)) {
            if (this.fallback == null) {
                this.actual.onError(new TimeoutException());
            } else {
                this.fallback.subscribe(this.otherObserver);
            }
        }
    }
}

