/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.DisposableHelper;

final class MaybeOnErrorComplete$OnErrorCompleteMaybeObserver<T>
implements MaybeObserver<T>,
Disposable {
    final MaybeObserver<? super T> actual;
    final Predicate<? super Throwable> predicate;
    Disposable d;

    MaybeOnErrorComplete$OnErrorCompleteMaybeObserver(MaybeObserver<? super T> actual, Predicate<? super Throwable> predicate) {
        this.actual = actual;
        this.predicate = predicate;
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.actual.onSuccess(value);
    }

    @Override
    public void onError(Throwable e2) {
        boolean b2;
        try {
            b2 = this.predicate.test(e2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(new CompositeException(e2, ex2));
            return;
        }
        if (b2) {
            this.actual.onComplete();
        } else {
            this.actual.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        this.d.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }
}

