/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.maybe.MaybeMergeArray$SimpleQueueWithConsumerIndex;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

final class MaybeMergeArray$MergeMaybeObserver<T>
extends BasicIntQueueSubscription<T>
implements MaybeObserver<T> {
    private static final long serialVersionUID = -660395290758764731L;
    final Yx<? super T> actual;
    final CompositeDisposable set;
    final AtomicLong requested;
    final MaybeMergeArray$SimpleQueueWithConsumerIndex<Object> queue;
    final AtomicThrowable error;
    final int sourceCount;
    volatile boolean cancelled;
    boolean outputFused;
    long consumed;

    MaybeMergeArray$MergeMaybeObserver(Yx<? super T> actual, int sourceCount, MaybeMergeArray$SimpleQueueWithConsumerIndex<Object> queue) {
        this.actual = actual;
        this.sourceCount = sourceCount;
        this.set = new CompositeDisposable();
        this.requested = new AtomicLong();
        this.error = new AtomicThrowable();
        this.queue = queue;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    @Nullable
    public T poll() {
        Object o2;
        while ((o2 = this.queue.poll()) == NotificationLite.COMPLETE) {
        }
        return (T)o2;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.set.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d2) {
        this.set.add(d2);
    }

    @Override
    public void onSuccess(T value) {
        this.queue.offer(value);
        this.drain();
    }

    @Override
    public void onError(Throwable e2) {
        if (this.error.addThrowable(e2)) {
            this.set.dispose();
            this.queue.offer((Object)NotificationLite.COMPLETE);
            this.drain();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        this.queue.offer((Object)NotificationLite.COMPLETE);
        this.drain();
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    void drainNormal() {
        int missed = 1;
        Yx<Object> a2 = this.actual;
        MaybeMergeArray$SimpleQueueWithConsumerIndex<Object> q2 = this.queue;
        long e2 = this.consumed;
        do {
            Throwable ex2;
            long r2 = this.requested.get();
            while (e2 != r2) {
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                ex2 = (Throwable)this.error.get();
                if (ex2 != null) {
                    q2.clear();
                    a2.onError(this.error.terminate());
                    return;
                }
                if (q2.consumerIndex() == this.sourceCount) {
                    a2.onComplete();
                    return;
                }
                Object v2 = q2.poll();
                if (v2 == null) break;
                if (v2 == NotificationLite.COMPLETE) continue;
                a2.onNext(v2);
                ++e2;
            }
            if (e2 == r2) {
                ex2 = (Throwable)this.error.get();
                if (ex2 != null) {
                    q2.clear();
                    a2.onError(this.error.terminate());
                    return;
                }
                while (q2.peek() == NotificationLite.COMPLETE) {
                    q2.drop();
                }
                if (q2.consumerIndex() == this.sourceCount) {
                    a2.onComplete();
                    return;
                }
            }
            this.consumed = e2;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    void drainFused() {
        int missed = 1;
        Yx<T> a2 = this.actual;
        MaybeMergeArray$SimpleQueueWithConsumerIndex<Object> q2 = this.queue;
        do {
            boolean d2;
            if (this.cancelled) {
                q2.clear();
                return;
            }
            Throwable ex2 = (Throwable)this.error.get();
            if (ex2 != null) {
                q2.clear();
                a2.onError(ex2);
                return;
            }
            boolean bl2 = d2 = q2.producerIndex() == this.sourceCount;
            if (!q2.isEmpty()) {
                a2.onNext(null);
            }
            if (!d2) continue;
            a2.onComplete();
            return;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        if (this.outputFused) {
            this.drainFused();
        } else {
            this.drainNormal();
        }
    }
}

