/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class MaybeFromFuture<T>
extends Maybe<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public MaybeFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d2 = Disposables.empty();
        observer.onSubscribe(d2);
        if (!d2.isDisposed()) {
            T v2;
            try {
                v2 = this.timeout <= 0L ? this.future.get() : this.future.get(this.timeout, this.unit);
            }
            catch (InterruptedException ex2) {
                if (!d2.isDisposed()) {
                    observer.onError(ex2);
                }
                return;
            }
            catch (ExecutionException ex3) {
                if (!d2.isDisposed()) {
                    observer.onError(ex3.getCause());
                }
                return;
            }
            catch (TimeoutException ex4) {
                if (!d2.isDisposed()) {
                    observer.onError(ex4);
                }
                return;
            }
            if (!d2.isDisposed()) {
                if (v2 == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v2);
                }
            }
        }
    }
}

