/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.MaybeFlatMapBiSelector$FlatMapBiMainObserver$InnerObserver;

final class MaybeFlatMapBiSelector$FlatMapBiMainObserver<T, U, R>
implements MaybeObserver<T>,
Disposable {
    final Function<? super T, ? extends MaybeSource<? extends U>> mapper;
    final MaybeFlatMapBiSelector$FlatMapBiMainObserver$InnerObserver<T, U, R> inner;

    MaybeFlatMapBiSelector$FlatMapBiMainObserver(MaybeObserver<? super R> actual, Function<? super T, ? extends MaybeSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
        this.inner = new MaybeFlatMapBiSelector$FlatMapBiMainObserver$InnerObserver<T, U, R>(actual, resultSelector);
        this.mapper = mapper;
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this.inner);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.inner.get());
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.setOnce(this.inner, d2)) {
            this.inner.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        MaybeSource<U> next;
        try {
            next = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null MaybeSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.inner.actual.onError(ex2);
            return;
        }
        if (DisposableHelper.replace(this.inner, null)) {
            this.inner.value = value;
            next.subscribe(this.inner);
        }
    }

    @Override
    public void onError(Throwable e2) {
        this.inner.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.inner.actual.onComplete();
    }
}

