/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.disposables.DisposableHelper;

final class MaybeDoOnEvent$DoOnEventMaybeObserver<T>
implements MaybeObserver<T>,
Disposable {
    final MaybeObserver<? super T> actual;
    final BiConsumer<? super T, ? super Throwable> onEvent;
    Disposable d;

    MaybeDoOnEvent$DoOnEventMaybeObserver(MaybeObserver<? super T> actual, BiConsumer<? super T, ? super Throwable> onEvent) {
        this.actual = actual;
        this.onEvent = onEvent;
    }

    @Override
    public void dispose() {
        this.d.dispose();
        this.d = DisposableHelper.DISPOSED;
    }

    @Override
    public boolean isDisposed() {
        return this.d.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d2) {
        if (DisposableHelper.validate(this.d, d2)) {
            this.d = d2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onSuccess(T value) {
        this.d = DisposableHelper.DISPOSED;
        try {
            this.onEvent.accept(value, null);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(ex2);
            return;
        }
        this.actual.onSuccess(value);
    }

    @Override
    public void onError(Throwable e2) {
        this.d = DisposableHelper.DISPOSED;
        try {
            this.onEvent.accept(null, e2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            e2 = new CompositeException(e2, ex2);
        }
        this.actual.onError(e2);
    }

    @Override
    public void onComplete() {
        this.d = DisposableHelper.DISPOSED;
        try {
            this.onEvent.accept(null, null);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.actual.onError(ex2);
            return;
        }
        this.actual.onComplete();
    }
}

