/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableZipIterable$ZipIterableSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Iterator;

public final class FlowableZipIterable<T, U, V>
extends AbstractFlowableWithUpstream<T, V> {
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public FlowableZipIterable(Flowable<T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        super(source);
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Yx<? super V> t2) {
        boolean b2;
        Iterator<U> it2;
        try {
            it2 = ObjectHelper.requireNonNull(this.other.iterator(), "The iterator returned by other is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptySubscription.error(e2, t2);
            return;
        }
        try {
            b2 = it2.hasNext();
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            EmptySubscription.error(e3, t2);
            return;
        }
        if (!b2) {
            EmptySubscription.complete(t2);
            return;
        }
        this.source.subscribe(new FlowableZipIterable$ZipIterableSubscriber<T, U, V>(t2, it2, this.zipper));
    }
}

